// Copyright 2014 Google Inc. All Rights Reserved.

#include "common.h"
#include "ProtocolEndpointBase.h"

void ProtocolEndpointBase::onChannelOpened(uint8_t channelId) {
    mChannelId = channelId;
    mConnected = true;
}

bool ProtocolEndpointBase::mayOpenChannel(uint8_t channelId) {
    /* Can only accept one connection by default. */
    return !mConnected;
}

bool ProtocolEndpointBase::onChannelClosed(uint8_t channelId) {
    if (!mConnected) {
        return false;
    }
    mConnected = false;
    return true;
}
